# model parameters
r = 1.1
K = 100
D = 1
# L is the length of our one-dimensional community
L = 300
N = rep(0,L)
N[floor(L/2)] = K
# dt is the timestep for iterating the reaction-diffusion
# equation
dt = 0.01
ts = seq(0,100,dt)

for ( i in 2:length(ts) )
  {
  # iterate the discretised reaction-diffusion equation
  dN_dt = r*N*(1-N/K) + D*c(0,diff(N,differences=2),0)
  N = pmax(0,N+dN_dt*dt)
  # draw the current spatial distribution
  plot(1:L,N,type='l',ylim=c(0,K),xlab='x',ylab='N')
  } 
